# all the ports of interest
#### NOTE!!! This is the file /usr/local/transfer/ELPORTS.pl
####         which is also /usr/local/annex/dialup/PORTS.pl (hard link)
####         When changing this file, also change
####           -- telephone.num
####           -- typhaon:/home/luyer/snmp/perl/config.pl (port counts)

##############################################################################
#        Maps annex identifier+port number to modem type for each
#         class of modems 

#fast
$ports{"f"} = {m17=>"V",m18=>"V",m19=>"V",m20=>"V",m21=>"V",m22=>"V",
	       i16=>"V",i17=>"V",i18=>"V",i19=>"V",i20=>"V",i21=>"V",
	       i22=>"V",i23=>"V",
	       m23=>"V",m24=>"V",m25=>"V",m26=>"V",m27=>"V",
	       m28=>"V",m29=>"V",m30=>"V",m31=>"V",m32=>"V",
	       i39=>"V",i40=>"V",i4=>"d",i5=>"a",i7=>"d",i8=>"d",i9=>"d",
	       i10=>"d",i11=>"d",i12=>"d",i13=>"d",
		i15=>"a",i24=>"d",i25=>"d",i26=>"d",i28=>"d",i29=>"d",i30=>"d",
		i30=>"d",i31=>"a",i32=>"a",i33=>"a",i35=>"d",i37=>"d",i41=>"d",
		i42=>"a",i43=>"a"
};
#night
$ports{"n"} = {m10=>"a",m11=>"a",m12=>"a",m13=>"a",
		m14=>"a",m15=>"a",m16=>"a",
	        a19=>"a",a20=>"a",
		a21=>"a",a22=>"a",a23=>"a",a24=>"a",a25=>"a",a26=>"a",a27=>"a",
	        a28=>"a",a29=>"a",a30=>"a",
		a31=>"a",a32=>"a",a33=>"a",a34=>"a",
	        m40=>"a",m41=>"a",m42=>"a",m43=>"a",m44=>"a",
		m45=>"a",m46=>"a",m47=>"a",m48=>"a",
		t1=>"a",t2=>"a",t3=>"a",t4=>"a",t5=>"a",t6=>"a",t7=>"a",
		t8=>"a",t9=>"a",t10=>"a",t11=>"a",t13=>"a",t14=>"a",t15=>"a",
	        t17=>"a",t18=>"a",t19=>"a",t20=>"a",t21=>"a",t22=>"a",
	        t23=>"a",t24=>"a",t25=>"a",t26=>"a",t27=>"a",t28=>"a"};
#pay
$ports{"p"} = {a1=>"V",a2=>"V",a3=>"V",a4=>"V",a5=>"V",a6=>"V",a7=>"V",a8=>"V",
	       a9=>"V",a10=>"V",a11=>"V",a12=>"V",a13=>"V",a14=>"V",a15=>"V",
	       a16=>"V"};

#isdn connected (UWA)
for ($i = 1; $i <= 62; $i++) {
  $ports{"i"}{"l".$i} = "B";
}

#slow
$ports{"s"} = {};

#isdn connected (GRAD)
for ($i = 1; $i <= 62; $i++) {
  $ports{"c"}{"s".$i} = "B";
}

# GRAD ports with modems
$ports{"g"} = {
   p1=>"X", p2=>"X", p3=>"X", p4=>"X", p5=>"X", p6=>"X", p7=>"X", p8=>"X",
   p9=>"X", p10=>"X",p11=>"X",p12=>"X",p13=>"X",p14=>"X",p15=>"X",p16=>"X",
   p19=>"X",p20=>"X",p21=>"X",p22=>"X",p23=>"X",p24=>"X",p25=>"X",p26=>"X",
   p27=>"X",p28=>"X",p29=>"X",p30=>"X",p31=>"X",p32=>"X",p33=>"X",p34=>"X",
   p35=>"X",p36=>"X",
   p37=>"X",p38=>"X",p39=>"X",p40=>"X",p41=>"X",p42=>"X",p43=>"X",p44=>"X",
   p45=>"X",p46=>"X",p47=>"X",p48=>"X",p49=>"X",p50=>"X",p51=>"X",p52=>"X",
   p53=>"X",p54=>"X",
   p55=>"X",p56=>"X",p57=>"X",p58=>"X",p59=>"X",p60=>"X",p61=>"X",p62=>"X",
   p63=>"X",p64=>"X",p65=>"X",p66=>"X",p67=>"X",p68=>"X",p69=>"X",p70=>"X",
   p71=>"X",p72=>"X"
};

#ACS
$ports{"x"} = {t29=>"N", t30=>"N", t31=>"N"};

###################################################################################
#  maps annex id into IP address and annex name
#
$annex{"i"} = "130.95.128.20"; $annexn{"i"} = "illium";
$annex{"m"} = "130.95.128.21"; $annexn{"m"} = "mycenae";
$annex{"t"} = "130.95.128.22"; $annexn{"t"} = "tiryns";
$annex{"a"} = "130.95.128.23"; $annexn{"a"} = "aulis";
$annex{"l"} = "130.95.128.24"; $annexn{"l"} = "lokris"; $annexs{"l"} = "arduna";
$annex{"p"} = "203.24.97.2";   $annexn{"p"} = "pylos";
$annex{"s"} = "203.24.97.5";   $annexn{"s"} = "scamander";

############################################################
#  For each modem class
#           Try to maintain this number of free lines
$lines_free{'n'} = 2;         #night 33K UWA dialups (mycenae, tyrins)
$lines_free{'s'} = 0;         #slower <33k UWA dailups (illium)
$lines_free{'f'} = 2;         #faster 33K  UWA dailups (illium)
$lines_free{'x'} = 0;         #admin dialups (tyrins)
$lines_free{'p'} = 6;         #pay 33K UWA dialups (aulis)
$lines_free{'i'} = 14+15;      #isdn <=44K UWA dialups (lokris)
$lines_free{'g'} = 0;         #cygnus 33K dialups (pylos)
$lines_free{'c'} = 0;         #cygnus <=56K dialups (scamander)
#
sub x {};
###########################################################
# For each user class
#     routine for login time check 
$over_time{'L'} = \&student_timer;
$over_time{'666'} = \&student_timer;
$over_time{'H'} = \&x;
$over_time{'N'} = \&x;
$over_time{' '} = \&x;
 
###########################################################
# For each user class
#      routine for checking if they have logged on again too soon
$re_login{'L'} = \&keep_out;
$re_login{'H'} = \&keep_out;
$re_login{'666'} = \&keep_out;
$re_login{'N'} = \&x;
$re_login{' '} = \&x;
 
###########################################################
# For each modem class
#    routine for mentaining free lines
$keep_free{'n'} = \&keep_free_s;
$keep_free{'s'} = \&keep_free_n;
$keep_free{'f'} = \&keep_free_n;
$keep_free{'p'} = \&keep_free_a;
$keep_free{'x'} = \&x;
$keep_free{'i'} = \&keep_free_isdn;
$isdn_keep_free{'i'}{'93476300'} = "n"; # no kick-off
$keep_free{'g'} = \&x;
$keep_free{'c'} = \&x;
############################################################
# For each modem class
#    routine for deciding if a line is unused and so not working
$unused_check{'n'} = \&mtime_out;
$unused_check{'s'} = \&mtime_i;
$unused_check{'f'} = \&mtime_i;
$unused_check{'x'} = \&x;
$unused_check{'p'} = \&x;
$unused_check{'i'} = \&x;
$unused_check{'g'} = \&mtime_i;
$unused_check{'c'} = \&x;

############################################################
# For each modem class
#    Do you kick students of for time exceeded
$time_check{'n'} = 1;
$time_check{'s'} = 1;
$time_check{'f'} = 1;
$time_check{'x'} = 1;
$time_check{'p'} = 1;
$time_check{'i'} = 1;
$time_check{'g'} = 0;
$time_check{'c'} = 0;

###########################################################
#  Finger proc by annex
$finger_get{'i'} = \&finger;
$finger_get{'m'} = \&finger;
$finger_get{'t'} = \&finger;
$finger_get{'a'} = \&finger;
$finger_get{'l'} = \&finger;
$finger_get{'p'} = \&finger;
$finger_get{'s'} = \&cfinger;

###########################################################
#  Build list of annex identifier+port number to modem class
@p_types = ('f', 'n', 'p', 's', 'x', 'i', 'g', 'c');
foreach $s (@p_types) {
    $p_cnt{$s} = keys %{$ports{$s}};
    foreach $p (keys %{$ports{$s}}) {
	$port_type{$p} = $s;
    }
}
1;
