# common subroutine for all this stuff

sub week {
  int(time()/604800);
}

package ELPORTS;
require "$main::home/lib/ELPORTS.pl";
# from elysium:/usr/local/transfer/perl/ELPORTS.pl
$ports{"c"} = {%{$ports{"s"}}, %{$ports{"f"}}};

package CYGPORTS;
# from cygnus:/usr/local/transfer/CYGPORTS.pl
require "$main::home/lib/CYGPORTS.pl";

package config;

%outdirs=("RouterD"  => "$main::home/lib/RouterD",
          "ServerD"  => "$main::home/lib/ServerD",
          "DiskD"    => "$main::home/lib/DiskD");

%pidfile=("RouterD"  => "$main::home/etc/RouterD.pid",
	  "ServerD"  => "$main::home/etc/ServerD.pid",
	  "DiskD"    => "$main::home/etc/DiskD.pid");

$mib = "$main::home/etc/small.mib";
#
%routers=("muchacho" => "130.95.128.128",
	  "sombrero" => "130.95.22.1",
	  "gringo"   => "130.95.128.17",
	  "sandanista" => "130.95.128.15",
	  "zapatista" => "130.95.128.33",
	  "hacienda" => "130.95.128.16",
	  "diablo"   => "130.95.128.19",
	  "pancho"   => "130.95.130.1",
	  "ranchero" => "130.95.162.1",
	  "bandido"  => "130.95.128.14",
	  "reynaldo" => "130.95.128.11",
	  "pueblo"   => "130.95.152.1",
	  "cactus"   => "130.95.128.10",
	  "senorita" => "130.95.14.1",
	  "chiquita" => "130.95.50.1",
	  "junta"    => "130.95.128.35",
	  "perro"    => "130.95.152.4",
	  "poco"     => "130.95.128.18",
	  "loco"     => "130.95.233.1",
	  "suelo"    => "130.95.214.1",
	  "scamander" => "203.24.97.5",
	  "splatter.library" => "130.95.128.40",
	  "camino"   => "130.95.152.13",
	  "salsa"    =>	"203.24.97.3",
	  "pylos"    => "203.24.97.2", # This is specially handled in RouterD
	  "border-1" => "192.168.127.1",
	  "WAIX"     => "192.168.127.2");

%servers=("illium"   => "130.95.128.20",
	  "mycenae"  => "130.95.128.21",
	  "tiryns"   => "130.95.128.22",
	  "aulis"    => "130.95.128.23",
	  "lokris"   => "130.95.128.24",
	  "pylos"    => "203.24.97.2");

%numbers=("9347 4002" => [keys %{$ELPORTS'ports{"p"}}],
	  "9347 6333/4" => [keys %{$ELPORTS'ports{"i"}}],
          "9380 1630" => [keys %{$ELPORTS'ports{"n"}}],
	  "9381 2200" => [keys %{$ELPORTS'ports{"c"}}],
	  "9381 3054" => [keys %{$ELPORTS'ports{"f"}}],
	  "9388 8000" => [keys %{$CYGPORTS'ports{"c"}}],
	  "ACS" => [keys %{$ELPORTS'ports{"x"}}]);

$annex={%ELPORTS'annexn,%CYGPORTS'annexn};

%ports=("illium"     => 35,  # 34 user + 1 data plinth
	"mycenae"    => 54,  # 48 user + 4 data plinth + 1 dialix + 1 vc
	"tiryns"     => 32,  # 26 user + 4 netcomm + 2 data plinth
	"aulis"      => 16,  # 16 user
	"lokris"     => 40,  # 40 user (ISDN)
	"pylos"      => 72); # 70 user + 1 ucs + 1 it

$maxports=72;

%comm=("illium"      => "commu1",
       "mycenae"     => "commu1",
       "tiryns"      => "commu1",
       "aulis"       => "commu1",
       "lokris"      => "commu1",
       "pylos"       => "commu2");

%pports=("illium"    => 64,
	 "mycenae"   => 48,
	 "tiryns"    => 32,
	 "aulis"     => 36,
	 "pylos"     => 72,
	 "lokris"    => 62
);

%comment=("pylos"    => "for cygnus users",
	  "mycenae"  => "after hours",
	  "tiryns"   => "after hours",
	  "aulis"    => "for staff - charged",
	  "lokris"   => "for staff - in testing",
	  "9380-1630" => "after hours",
	  "9388-8000" => "for cygnus users",
	  "9347-4002" => "for staff - charged",
	  "9347-6333/4" => "for staff - in testing",
	  "ACS"	     => "private");

$sampleinterval = 60;

%default=("RouterD" => "muchacho/01-ATM1.0",
	  "ServerD" => "9381 2200",
	  "DiskD"   => "enyo-0");

# Speed for all interfaces
%speed=(# Standard i/f types
	"Fddi"			=> 100000000,
	"FastEthernet"		=> 100000000,
	"Ethernet"		=>  10000000,
	"TokenRing"		=>  16000000,
	"ATM"			=>  34000000,
	"BRI"			=>    128000,
	"B-Channel"		=>     64000,
	# 100M @ 10M
	"sandanista/12-Bay_Networks_BayStack_304_Ethernet_Switch_"
				=>  10000000, # 100M port @ 10M
	"zapatista/05-10.100_utp_ethernet_(cat_3.5)"
				=>  10000000, # 100M port @ 10M
	"zapatista/06-10.100_utp_ethernet_(cat_3.5)"
				=>  10000000, # 100M port @ 10M
	# Sync serial & Tunnel
	"muchacho/04-Tunnel0"	=>   2000000, # Tunnel over WAIX 2Mbps PAPL
	"salsa/05-Tunnel0"	=>    128000, # Software-shaped tunnel in tunnel
	"WAIX/01-Serial0"	=>   2000000, # WAIX 2Mbps PAPL
	"border-1/01-Serial0"	=>   2000000, # Tesltra 2Mbps
	"border-1/02-Serial1"	=>   2000000, # WAIX 2Mbps PAPL
	"hacienda/14-Serial0"	=>     64000, # KEMH 64k
	"chiquita/01-Serial0"	=>     64000, # KEMH 64k
	"hacienda/15-Serial1"	=>     64000, # FH 64k
	"sombrero/01-Serial0"	=>     64000, # FH 64k
	"senorita/01-Serial0"	=>   2000000, # PMH 2Mbps
	"senorita/02-Serial1"	=>   2000000, # PMH 2Mbps
	"hacienda/17-Serial3"	=>   2000000, # QEII 2Mbps
	"pueblo/14-Serial0"	=>   2000000, # QEII 2Mbps
	"hacienda/18-Serial4"	=>    128000, # RPH 128k
	"pancho/04-Serial0"	=>    128000, # RPH 128k
	"hacienda/19-Serial5"	=>    256000, # Graylands 256k
	"loco/01-Serial0"	=>    256000, # Graylands 256k
	"pancho/05-Serial1"	=>   2000000, # QEII-RPH 2Mbps
	"perro/01-Serial0"	=>   2000000, # QEII-RPH 2Mbps
	"salsa/04-Serial0"	=>     64000, # WT 64k
	# Interface not in use
	"pueblo/15-Serial1"	=>         1,
	# Async serial
	"pancho/06-Async1"	=>      9600, # RPH Radiology
	"pylos/00-asy17"	=>     28800);# IT Modem

# Height for interfaces which can exceed 100% (compression, or shaping)
%height=("salsa/05-Tunnel0"	=> 500,
	 "pylos/00-asy17"	=> 200);

package router;

sub gauge {
	my $gauge;

	$_ = shift;
	if(exists($config'speed{$_})) {
		$gauge = $config'speed{$_};
	} elsif (/FastEthernet|fast_ethernet|10.100_utp|100Base|_ISL_/) {
		$gauge = $config'speed{"FastEthernet"};
	} elsif (/Ethernet/ || /10Base/) {
		$gauge = $config'speed{"Ethernet"};
	} elsif (/TokenRing/) {
		$gauge = $config'speed{"TokenRing"};
	} elsif (/Fddi/) {
		$gauge = $config'speed{"Fddi"};
	} elsif (/ATM/) {
		$gauge = $config'speed{"ATM"};
	} elsif (/B-Channel/) {
		$gauge = $config'speed{"B-Channel"};
	} elsif (/BRI/) {
		$gauge = $config'speed{"BRI"};
	}
	$gauge;
}

sub ifshow {
	my ($nm, $hs, $pr, $px);
	($hs,$pr,$nm) = split(/[-\/]/,$_[0],3);
	$nm =~ s/Ethernet/Ethernet Transceiver /;
	$nm =~ s/Serial/Synchronous Serial /;
	$nm =~ s/Async/Asynchronous Serial /;
	$nm =~ s/asy/Asynchronous Serial /;
	$nm =~ s/BRI/ISDN BRI /;
	$nm =~ s/:_B-Channel_/ B-Channel /;
	$nm =~ s/ATM/ATM /;
	$px = $pr + 1;
	if($nm =~ /Bay_Networks_BayStack_304/) {
		if($px < 13) {
			$nm = "10BaseT Ethernet - port $px";
		} elsif($px == 13) {
			$nm = "100BaseTX Ethernet - port $px";
		} elsif(/not_present/) {
			$nm = "MDA Port (not present) - port $px";
		} else {
			$nm = "MDA Port - port $px";
		}
	}
	$px -= 19 if $px > 19;
	$px -= 16 if $px > 16;
	$nm =~ s/Cisco_Catalyst_(Catalyst_|CAT)3000_10BaseT_HW_Rev_[0-9]+\;_SW_[0-9].*$/10BaseT Ethernet $px/;
	$nm =~ s/Cisco_Catalyst_(CatalystPort|WS-X3003)_10BaseF_HW_Rev_[0-9]+\;_SW_[0-9].*$/10BaseF Ethernet $px/;
	$nm =~ s/Cisco_Catalyst_WS-X3010_ISL_TX_HW_Rev_[0-9]+\;_SW_[0-9].*$/100BaseTX Ethernet $px/;
	$nm =~ s/Cisco_Catalyst_3000_HW_Rev_[0-9]+\;_SW_[0-9].*VLAN_/Catalyst VLAN /;
	$nm =~ s/Cisco_Catalyst_3000_HW_Rev_[0-9]+\;_SW_[0-9].*$/Catalyst/;
	$px -= 2 if $px > 2;
	$px -= 2 if $px > 2;
	$nm =~ s/utp_fast_ethernet_\(cat_5\)/100BaseTX Ethernet $px/;
	$nm =~ s/10\.100_utp_ethernet_\(cat_3\.5\)/10BaseT-100BaseTX Ethernet $px/;
	return "$hs-$pr ($nm)";
}

sub ifunshow {
	my $nm = shift;
	if($nm =~ /^([A-Za-z0-9\.]+)[-\/]([0-9]+)/) {
		return glob "$1/$2-*";
	} else {
		return $config'default('RouterD');
	}
}

sub rtshow {
	my $nm = shift;
	my $pts = 0;
	my $ptc;
	if($nm eq "*") {
		for $ptc (values %main'ports) {
			$pts += $ptc;
		}
		return "* ($pts ports)";
	}
	return "$nm ($main'ports{$nm} ports)";
}

sub rtunshow {
	my $nm = (split(/ /,$_[0]))[0];
	if($nm) {
		return $nm;
	} else {
		return (split(/[-\/]/,$config'default{'RouterD'}))[0];
	}
}

1;
