require "$home/lib/webgraph.pl";
require "$home/lib/config.pl";

sub ProcessBatch {
        my $rtr = shift;
        for $rtrdisk (glob "$rtr-*") {
                ProcessFile($rtrdisk);
                print "<P>\n";
        }
}

sub ProcessFile {
	my $file = shift;
	my ($oldtime, $time, $dtime, $oldbytesin, $bytesin,
		$cin, $oldbytesout, $bytesout, $cout);

	printf("<P><H3 ALIGN=CENTER>%s</H3>", ifshow(($_ = $file)));
	webgraph'InitGraph("traffic", "kbits/sec",
		"Read Data<BR>Average \@\@avg kbits/sec",
		"Written Data<BR>Average \@\@avg kbits/sec");
	if(time() % 604800 > $Sample * 60) {
	    open(IN,"-|") || exec "/usr/bin/tail","-$Sample",$file;
	} else {
	    $wm1 = &week - 1;
	    $Sample -= (time() % 604800) / 60;
	    $Sample = int($Sample);
	    open(IN,"-|") || exec "/usr/bin/tail -$Sample ../$wm1/$file ;".
                                  "/bin/cat $file";
	    undef $wm1;
	}
	$_ = <IN>;
	chop;
	($oldtime,$oldbytesin,$oldbytesout) = split /\|/;
	while(<IN>) {
		chop;
		($time,$bytesin,$bytesout) = split /\|/;
		$dtime = $time - $oldtime;
		$cin = int($bytesin - $oldbytesin);
		$cout = int($bytesout - $oldbytesout);
		$next = ($oldbytesout == -1) || !$dtime;
		$oldbytesin = $bytesin;
		$oldbytesout = $bytesout;
		$oldtime = $time;
		next if ($bytesout == -1) || $next;
		$cin = 8 * $cin / (1000 * $dtime);
		$cout = 8 * $cout / (1000 * $dtime);
		webgraph'AppendData("traffic", $time, $cin, $cout)
			if ($cin + $cout < 335544);
	}
	webgraph'PrintGraph("traffic");
	webgraph'DeleteGraph("traffic");
}

sub ifshow {
	my ($nm, $hs, $pr, $px);
	($hs,$pr,$nm) = split(/-/,$_[0],3);
	$nm = "md0" if($hs eq "enyo" && $pr > 0);
	$nm = "home" if($hs eq "tartarus" && $pr > 0);
	$nm = "md0" if($hs eq "enyo2");
        $nm = "home" if($hs eq "cyllene");
        $nm = "boot" if ($pr == 0);
	return "$hs-$pr ($nm)";
}

sub ifunshow {
	my $nm = shift;
	if($nm =~ /^([a-z0-9\.]+)-([0-9]+)/) {
		$nm = "$1-$2";
		return $nm;
	} else {
		return $config'default('DiskD');
	}
}

sub rtshow {
        my $nm = shift;
        my $pts = 0;
        my $ptc;
        if($nm eq "*") {
                for $ptc (values %disks) {
                        $pts += $ptc;
                }
                return "* ($pts disks)";
        }
        return "$nm ($disks{$nm} disks)";
}

sub rtunshow {
        my $nm = (split(/ /,$_[0]))[0];
        if($nm) {
                return $nm;
        } else {
                return (split(/-/,$config'default{'DiskD'}))[0];
        }
}

1;
