require "$home/lib/webtable.pl";
require "$home/lib/config.pl";

sub ProcessBatch {
        my $rtr = shift;
        my @rtrports;
	print "<TABLE BORDER=1>";
	printf("<TR><TH>%s<TH WIDTH=50>From<TH WIDTH=50>To<TH WIDTH=30>%<BR>IN<TH WIDTH=30>%%<BR>OUT<TH WIDTH=30>errs<BR>IN<TH WIDTH=30>errs<BR>OUT", router'rtshow($rtr));
        for $rtrport (glob "$rtr/??-*") {
                ProcessFile($rtrport);
        }
	print "</TABLE>";
}

sub ProcessFile {
	my $file = shift;
	my ($maxrate, $oldtime, $time, $dtime, $oldbytesin, $bytesin,
		$cin, $oldbytesout, $bytesout, $cout, $olderrin, $errin,
		$rerrin, $rerrout, $gauge);

	printf("<TR><TD>%s", router'ifshow(($_ = $file)));
	$gauge = router'gauge($file);
	if (exists($config'height{$file})) {
		$maxrate = $config'height{$file};
	} else {
		$maxrate = 100;
	}
	if (!defined $gauge) {
		print "<TR>There is no gauge set for this port.\n";
		return;
	}
	webtable'InitTable("traffic");
	if(time() % 604800 > $Sample * 60) {
	    open(IN,"-|") || exec "/usr/bin/tail","-$Sample",$file;
	} else {
	    $wm1 = &week - 1;
	    $Sample -= (time() % 604800) / 60;
	    $Sample = int($Sample);
	    open(IN,"-|") || exec "/usr/bin/tail -$Sample ../$wm1/$file ;".
	                          "/bin/cat $file";
	    undef $wm1;
	}
	open(IN,"-|") || exec "/usr/bin/tail","-$Sample",$file;
	$_ = <IN>;
	chop;
	($oldtime,$oldbytesin,$oldbytesout,$olderrin,$olderrout) = split /\|/;
	while(<IN>) {
		chop;
		($time,$bytesin,$bytesout,$errin,$errout) = split /\|/;
		if ($bytesin >= $oldbytesin) {
			$cin = int($bytesin - $oldbytesin);
		} else {
			$cin = int(4294967296 - $oldbytesin + $bytesin);
		}
		$oldbytesin = $bytesin;
		if ($bytesout >= $oldbytesout) {
			$cout = int($bytesout - $oldbytesout);
		} else {
			$cout = int(4294967296 - $oldbytesout + $bytesout);
		}
		$oldbytesout = $bytesout;
		if ($errin >= $olderrin) {
			$rerrin = int($errin - $olderrin);
		} else {
			$rerrin = int(4294967296 - $olderrin + $errin);
		}
		$olderrin = $errin;
		if ($errout >= $olderrout) {
			$rerrout = int($errout - $olderrout);
		} else {
			$rerrout = int(4294967296 - $olderrout + $errout);
		}
		$olderrout = $errout;
		$dtime = $time - $oldtime;
		next if !$dtime;
		$oldtime = $time;
		$cin = 100 * $cin * 8 / $dtime / $gauge;
		$cout = 100 * $cout * 8 / $dtime / $gauge;
		$rerrin /= $dtime;
		$rerrout /= $dtime;
		if (($cin <= $maxrate) && ($cout <= $maxrate)) {
			webtable'AppendData("traffic", $time, $cin, $cout,
			                    $rerrin, $rerrout);
		}
	}
	webtable'PrintTable("traffic");
	webtable'DeleteTable("traffic");
}

1;
