require "$home/lib/webgraph.pl";
require "$home/lib/config.pl";

sub ProcessBatch {
        my $rtr = shift;
        my @rtrports;
        @rtrports = glob "$rtr/??-*";
        for $rtrport (@rtrports) {
                ProcessFile($rtrport);
                print "<P>\n";
        }
}

sub ProcessFile {
	my $file = shift;
	my ($maxrate, $oldtime, $time, $dtime, $oldbytesin, $bytesin,
		$cin, $oldbytesout, $bytesout, $cout, $olderrin, $errin,
		$rerrin, $rerrout, $gauge);

	printf("<P><H3 ALIGN=CENTER>%s</H3>", router'ifshow($file));
	$gauge = router'gauge($file);
	if (exists($config'height{$file})) {
		$maxrate = $config'height{$file};
	} else {
		$maxrate = 100;
	}
	if (!defined $gauge) {
		print "<P ALIGN=CENTER><STRONG>There is no gauge set for this ";
		print "port.  No graph can be drawn.</STRONG>\n";
		return;
	}
	print "<P ALIGN=CENTER><EM>Gauge: $gauge bps</EM>\n";
	webgraph'InitGraph("traffic", "%",
		"Received Traffic<BR>Average \@\@avg% Utilization",
		"Transmitted Traffic<BR>Average \@\@avg% Utilization");
	if($in{'Submit'} eq "Traffic and Errors") {
		webgraph'InitGraph("errors", "p/s",
			"Input Errors<BR>Average \@\@avg packets/second",
			"Output Errors<BR>Average \@\@avg packets/second");
	}
	if(time() % 604800 > $Sample * 60) {
	    open(IN,"-|") || exec "/usr/bin/tail","-$Sample",$file;
	} else {
	    $wm1 = &week - 1;
	    $Sample -= (time() % 604800) / 60;
            $Sample = int($Sample);
	    open(IN,"-|") || exec "/usr/bin/tail -$Sample ../$wm1/$file ;".
	                          "/bin/cat $file";
	    undef $wm1;
	}
	$_ = <IN>;
	chop;
	($oldtime,$oldbytesin,$oldbytesout,$olderrin,$olderrout) = split /\|/;
	while(<IN>) {
		chop;
		($time,$bytesin,$bytesout,$errin,$errout) = split /\|/;
		if ($bytesin >= $oldbytesin) {
			$cin = int($bytesin - $oldbytesin);
		} else {
			$cin = int(4294967296 - $oldbytesin + $bytesin);
		}
		$oldbytesin = $bytesin;
		if ($bytesout >= $oldbytesout) {
			$cout = int($bytesout - $oldbytesout);
		} else {
			$cout = int(4294967296 - $oldbytesout + $bytesout);
		}
		$oldbytesout = $bytesout;
		if ($errin >= $olderrin) {
			$rerrin = int($errin - $olderrin);
		} else {
			$rerrin = int(4294967296 - $olderrin + $errin);
		}
		$olderrin = $errin;
		if ($errout >= $olderrout) {
			$rerrout = int($errout - $olderrout);
		} else {
			$rerrout = int(4294967296 - $olderrout + $errout);
		}
		$olderrout = $errout;
		$dtime = $time - $oldtime;
		next if !$dtime;
		$oldtime = $time;
		$cin = 100 * $cin * 8 / $dtime / $gauge;
		$cout = 100 * $cout * 8 / $dtime / $gauge;
		$rerrin /= $dtime;
		$rerrout /= $dtime;
		if (($cin <= $maxrate) && ($cout <= $maxrate)) {
			webgraph'AppendData("traffic", $time, $cin, $cout);
			next if($in{'Submit'} ne "Traffic and Errors");
			webgraph'AppendData("errors", $time, $rerrin, $rerrout);
		}
	}
	webgraph'PrintGraph("traffic");
	webgraph'DeleteGraph("traffic");
	return if ($in{'Submit'} ne "Traffic and Errors");
	webgraph'PrintGraph("errors");
	webgraph'DeleteGraph("errors");
}

1;
