package webgraph;

%graph = ( );

sub CgiStart {
my ($str, $key, $val);

  if($ENV{'REQUEST_METHOD'} ne 'GET') {
    print "Content-type: text/plain\n\n";
    print "You tried to access this form with a method other than GET.  Only GET\n";
    print "method is supported by this form.\n";
    exit;
  }

  for $str (split(/[&;]/,$ENV{'QUERY_STRING'})) {
    $str =~ s/\+/ /g;
    ($key, $val) = split(/=/,$str,2);
    $key =~ s/%(..)/pack("c",hex($1))/ge;
    $val =~ s/%(..)/pack("c",hex($1))/ge;
    $main::in{$key} = $val;
  }
}

sub AppendData {
my $graph = shift;
my $time = shift;
my $value = shift;
my $value2 = shift;

  if(shift) {
    die "Too many parameters to AppendData.\n";
  }
  if(!defined($value)) {
    die "Too few parameters to AppendData.\n";
  }
  if(!exists($graph{$graph})) {
    die "No such graph ($graph) in AppendData.\n";
  }
  if(defined($value2) ^ defined($graph{$graph}{"Titles"}[1])) {
    die "Incorrect number of fields for graph ($graph) in AppendData.\n";
  }
  $graph{$graph}{"Samples"}++;
  if(!exists($graph{$graph}{"TimeExtrema"})) {
    $graph{$graph}{"TimeExtrema"} = [ $time, $time ];
    $graph{$graph}{"Extrema"} = [ $value, $value ];
    if(defined($value2)) {
      if($value2 > $value) {
        $graph{$graph}{"Extrema"}[1] = $value2;
      } else { # $value2 <= $value
        $graph{$graph}{"Extrema"}[0] = $value2;
      }
    }
  } else {
    if($time < $graph{$graph}{"TimeExtrema"}[0]) {
      $graph{$graph}{"TimeExtrema"}[0] = $time;
    } elsif($time > $graph{$graph}{"TimeExtrema"}[1]) {
      $graph{$graph}{"TimeExtrema"}[1] = $time;
    }
    if($value < $graph{$graph}{"Extrema"}[0]) {
      $graph{$graph}{"Extrema"}[0] = $value;
    } elsif($value > $graph{$graph}{"Extrema"}[1]) {
      $graph{$graph}{"Extrema"}[1] = $value;
    }
    if(defined($value2)) {
      if($value2 < $graph{$graph}{"Extrema"}[0]) {
        $graph{$graph}{"Extrema"}[0] = $value2;
      } elsif($value2 > $graph{$graph}{"Extrema"}[1]) {
        $graph{$graph}{"Extrema"}[1] = $value2;
      }
    }
  }
  $graph{$graph}{"Data"}{$time} = [ $value, $value2 ];
  $graph{$graph}{"Sums"}[0] += $value;
  if(defined($value2)) {
    $graph{$graph}{"Sums"}[1] += $value2;
  }
}

sub PrintArray {
  my $array = shift;
  my $indent = shift;
  my $elem;

  if(shift) {
    die "Too many parameters to PrintArray.\n";
  }
  if(!defined($indent)) {
    die "Too few parameters to PrintArray.\n";
  }
  print $indent."Array Values:\n";
  for $elem (@{$array}) {
    if(!defined($elem)) {
      print $indent."  Undefined entry.\n";
    } elsif($elem =~ /^HASH\(.*\)$/) {
      PrintHash($elem, $indent."  ");
    } elsif($elem =~ /^ARRAY\(.*\)$/) {
      PrintArray($elem, $indent."  ");
    } else {
      print $indent."  Plain Value: $elem\n";
    }
  }
  print $indent."End of Array.\n";
}

sub PrintHash {
  my $hash = shift;
  my $indent = shift;
  my $elem;

  if(shift) {
    die "Too many parameters to PrintHash.\n";
  }
  if(!defined($indent)) {
    die "Too few parameters to PrintHash.\n";
  }
  print $indent."Hash Values:\n";
  for $elem (keys %{$hash}) {
    print $indent."  Element: $elem\n";
    if(!defined(${$hash}{$elem})) {
      print $indent."    Undefined entry.\n";
    } elsif(${$hash}{$elem} =~ /^HASH\(.*\)$/) {
      PrintHash(${$hash}{$elem}, $indent."    ");
    } elsif(${$hash}{$elem} =~ /^ARRAY\(.*\)$/) {
      PrintArray(${$hash}{$elem}, $indent."    ");
    } else {
      print $indent."    Plain Value: ${$hash}{$elem}\n";
    }
  }
  print $indent."End of Hash.\n";
}

sub DumpGraph {
my $graph = shift;

  if(shift) {
    die "Too many parameters to DumpGraph.\n";
  }
  if(!defined($graph)) {
    die "Too few parameters to DumpGraph.\n";
  }
  print "Graph: $graph\n";
  PrintHash($graph{$graph}, "  ");
}

sub InitGraph {
my $graph = shift;
my $unit = shift;
my $title = shift;
my $title2 = shift;

  if(shift) {
    die "Too many parameters to InitGraph.\n";
  }
  if(!defined($title)) {
    die "Too few parameters to InitGraph.\n";
  }
  if(exists($graph{$graph})) {
    die "Graph already exists ($graph) in InitGraph.\n";
  }
  %{$graph{$graph}} = ( "Titles" => [ $title, $title2 ],
			"Units" => $unit,
			"Samples" => 0 );
  if(defined($title2)) {
    $graph{$graph}{"Sums"} = [ 0, 0 ];
  } else {
    $graph{$graph}{"Sums"} = [ 0 ];
  }
}

sub Divide {
my $x = shift;
my $y = shift;

  if(!$y) {
     "##.##";
  } else {
     sprintf "%0.2f", $x / $y;
  }
}

sub ByNumber {
  $a <=> $b;
}

sub PrintTime {
my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst);

  ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(shift);
  printf "%d:%02d:%02d %d/%d/%d", $hour, $min, $sec, $mday, $mon + 1, $year;
}

sub PrintGraph {
my $graph = shift;
my $samples = $graph{$graph}{"Samples"};
my ($dividers, $divs, $display, $width, $tmp, $count, $itot, $icount, $height, $scale, $max);

  if(shift) {
    die "Too many parameters to PrintGraph.\n";
  }
  if(!defined($graph)) {
    die "Too few parameters to PrintGraph.\n";
  }
  print "<DIV ALIGN=CENTER>\n";
  print "<TABLE BORDER=0>\n";
  print "<TR>\n";
  print "<TD>";
  print "<IMG SRC=\"/pixels/white.gif\" WIDTH=1 HEIGHT=1 ALT=\"\">";
  print "<IMG SRC=\"/pixels/grey.gif\" WIDTH=1 HEIGHT=5 ALT=\"\">";
  print "<IMG SRC=\"/pixels/grey.gif\" WIDTH=390 HEIGHT=2 ALIGN=TOP ALT=\"\">";
  print "<IMG SRC=\"/pixels/grey.gif\" WIDTH=2 HEIGHT=5 ALT=\"\">";
  print "<TR>\n";
  print "<TH ALIGN=CENTER>";
  $tmp = $graph{$graph}{"Titles"}[0];
  $tmp =~ s/\@\@avg/&Divide($graph{$graph}{"Sums"}[0],$samples)/ge;
  print $tmp;
  print "<TR>\n";
  print "<TD>";
  print "<IMG SRC=\"/pixels/white.gif\" WIDTH=157 HEIGHT=1 ALT=\"\">";
  print "<IMG SRC=\"/pixels/grey.gif\" WIDTH=80 HEIGHT=2 ALT=\"\">";
  print "<TR>\n";
  print "<TD>";
  print "<IMG SRC=\"/pixels/white.gif\" WIDTH=5 HEIGHT=1 ALT=\"\">";
  $max = $graph{$graph}{"Extrema"}[1];
  $max = 0 if !defined($max);
  $max = int($max * 100) / 100 + 0.01;
  $scale = $max;
  $scale = 0.01 if !$scale;
  printf "<STRONG>%0.2f%s</STRONG>\n", $max, $graph{$graph}{"Units"};
  print "<TR>\n";
  print "<TD>";
  print "<IMG SRC=\"/pixels/white.gif\" WIDTH=7 HEIGHT=1 ALT=\"\">";
  print "<IMG SRC=\"/pixels/green.gif\" WIDTH=20 HEIGHT=1 ALT=\"\">";
  print "<IMG SRC=\"/pixels/green.gif\" WIDTH=1 HEIGHT=120 ALT=\"\">";
  if($samples) {
    $dividers = $graph{$graph}{"TimeExtrema"}[1];
    $dividers -= $dividers % 3600 + ($tmp = $graph{$graph}{"TimeExtrema"}[0]);
    $dividers /= 3600 if $dividers;
    $dividers = int($dividers);
    $divs = 1;
    if($dividers >= 50) {
      $divs = 24;
      $dividers = $graph{$graph}{"TimeExtrema"}[1];
      $dividers -= $dividers % (3600 * 24) +
                   ($tmp = $graph{$graph}{"TimeExtrema"}[0]);
      $dividers /= 3600 * 24 if $dividers;
      $dividers = int($dividers);
    }
    if($dividers >= 175) {
      print "[ Error: Time period too large in PrintGraph ]";
    } else {
      if($samples + $dividers > 350) {
        $display = 350 - $dividers;
      } else {
        $display = $samples;
      }
      $width = int((350 - $dividers)/$display);
      $scale = 120 / $scale;
      $tmp -= $tmp % (3600 * $divs) - 3600 * $divs;
      if($divs == 24) {
        $tmp -= 8 * 3600;
      }
      $count = $icount = $itot = 0;
      for $time (sort ByNumber keys %{$graph{$graph}{"Data"}}) {
        $count++;
        if(int($count * $display/$samples) > int(($count - 1) * $display/$samples)) {
          while ($time > $tmp) {
            if($divs == 24 || !(($tmp + 3600 * 8) % (3600 * 24))) {
              print "<IMG SRC=\"/pixels/blue.gif\" HEIGHT=120 WIDTH=1 ALT=\"\">";
	    } else {
              print "<IMG SRC=\"/pixels/red.gif\" HEIGHT=120 WIDTH=1 ALT=\"\">";
	    }
	    $tmp += 3600 * $divs;
          }
          $itot += $graph{$graph}{"Data"}{$time}[0];
          $icount++;
          $height = int($itot * $scale / $icount);
          if($count == $icount) {
            print "<IMG SRC=\"/pixels/black.gif\" HEIGHT=$height WIDTH=$width ALT=\"[ Graphic ]\">";
          } else {
            print "<IMG SRC=\"/pixels/black.gif\" HEIGHT=$height WIDTH=$width ALT=\"\">";
          }
	  $icount = $itot = 0;
        } else {
          $itot += $graph{$graph}{"Data"}{$time}[0];
          $icount++;
        }
      }
    }
  } else {
    print "[ No Data ]";
  }
  print "<TR>\n";
  print "<TD>";
  print "<IMG SRC=\"/pixels/white.gif\" WIDTH=5 HEIGHT=1 ALT=\"\">";
  printf "<STRONG>%0.2f%s</STRONG>", 0, $graph{$graph}{"Units"};
  print "<TR>\n";
  print "<TD>";
  print "<IMG SRC=\"/pixels/white.gif\" WIDTH=12 HEIGHT=1 ALT=\"\">";
  print "<IMG SRC=\"/pixels/grey.gif\" WIDTH=370 HEIGHT=2 ALT=\"\">";
  print "<TR>\n";
  print "<TD ALIGN=CENTER>";
  $icount = $graph{$graph}{"TimeExtrema"}[0];
  $itot = $graph{$graph}{"TimeExtrema"}[1];
  if($samples) {
    if($samples != 1) {
      printf "%0.1f second averages from ", $samples/$display * ($itot - $icount)/($samples - 1);
      PrintTime($icount);
      print " to ";
    } elsif($samples) {
      print "Single sample at ";
    }
    PrintTime($itot);
  }
  print ".\n";
  if($graph{$graph}{"Titles"}[1]) {
      print "<TR>\n";
      print "<TD>";
      print "<IMG SRC=\"/pixels/white.gif\" WIDTH=12 HEIGHT=1 ALT=\"\">";
      print "<IMG SRC=\"/pixels/grey.gif\" WIDTH=370 HEIGHT=2 ALT=\"\">";
      print "<TR>\n";
      print "<TD>";
      print "<IMG SRC=\"/pixels/white.gif\" WIDTH=5 HEIGHT=1 ALT=\"\">";
      printf "<STRONG>%0.2f%s</STRONG>\n", $max, $graph{$graph}{"Units"};
      print "<TR>\n";
      print "<TD>";
      print "<IMG SRC=\"/pixels/white.gif\" WIDTH=7 HEIGHT=1 ALT=\"\">";
      print "<IMG SRC=\"/pixels/green.gif\" WIDTH=20 HEIGHT=1 ALT=\"\">";
      print "<IMG SRC=\"/pixels/green.gif\" WIDTH=1 HEIGHT=120 ALT=\"\">";
      if($samples) {
        if($dividers >= 175) {
          print "[ Error: Time period too large in PrintGraph ]";
        } else {
          $tmp = $graph{$graph}{"TimeExtrema"}[0];
          $tmp -= $tmp % (3600 * $divs) - 3600 * $divs;
          if($divs == 24) {
            $tmp -= 8 * 3600;
          }
          $count = $icount = $itot = 0;
          for $time (sort ByNumber keys %{$graph{$graph}{"Data"}}) {
            $count++;
            if(int($count * $display/$samples) > int(($count - 1) * $display/$samples)) {
              while ($time > $tmp) {
                if($divs == 24 || !(($tmp + 3600 * 8) % (3600 * 24))) {
                  print "<IMG SRC=\"/pixels/blue.gif\" HEIGHT=120 WIDTH=1 ALIGN=BOTTOM ALT=\"\">";
    	        } else {
                  print "<IMG SRC=\"/pixels/red.gif\" HEIGHT=120 WIDTH=1 ALIGN=BOTTOM ALT=\"\">";
	        }
	        $tmp += 3600 * $divs;
              }
              $itot += $graph{$graph}{"Data"}{$time}[1];
              $icount++;
              $height = int($itot * $scale / $icount);
              if($count == $icount) {
                print "<IMG SRC=\"/pixels/black.gif\" HEIGHT=$height WIDTH=$width ALIGN=BOTTOM ALT=\"[ Graphic ]\">";
              } else {
                print "<IMG SRC=\"/pixels/black.gif\" HEIGHT=$height WIDTH=$width ALIGN=BOTTOM ALT=\"\">";
              }
    	      $icount = $itot = 0;
            } else {
              $itot += $graph{$graph}{"Data"}{$time}[1];
              $icount++;
            }
          }
        }
      } else {
        print "[ No Data ]";
      }
      print "<TR>\n";
      print "<TD>";
      print "<IMG SRC=\"/pixels/white.gif\" WIDTH=5 HEIGHT=1 ALT=\"\">";
      printf "<STRONG>%0.2f%s</STRONG>\n", 0, $graph{$graph}{"Units"};
      print "<TR>\n";
      print "<TD>";
      print "<IMG SRC=\"/pixels/white.gif\" WIDTH=157 HEIGHT=1 ALT=\"\">";
      print "<IMG SRC=\"/pixels/grey.gif\" WIDTH=80 HEIGHT=2 ALT=\"\">";
      print "<TR>\n";
      print "<TH ALIGN=CENTER>";
      $tmp = $graph{$graph}{"Titles"}[1];
      $tmp =~ s/\@\@avg/&Divide($graph{$graph}{"Sums"}[1],$samples)/ge;
      print $tmp;
  }
  print "<TR>\n";
  print "<TD VALIGN=BOTTOM>";
  print "<IMG SRC=\"/pixels/white.gif\" WIDTH=1 HEIGHT=1 ALT=\"\">";
  print "<IMG SRC=\"/pixels/grey.gif\" WIDTH=1 HEIGHT=5 ALT=\"\">";
  print "<IMG SRC=\"/pixels/grey.gif\" WIDTH=390 HEIGHT=2 ALT=\"\">";
  print "<IMG SRC=\"/pixels/grey.gif\" WIDTH=2 HEIGHT=5 ALT=\"\">";
  print "</TABLE>\n";
  print "</DIV>\n";
}

sub DeleteGraph {
my $graph = shift;

  if(shift) {
    die "Too many parameters to DeleteGraph.\n";
  }
  if(!defined($graph)) {
    die "Too few parameters to DeleteGraph.\n";
  }
  if(!exists($graph{$graph})) {
    die "Non-existant graph ($graph) in DeleteGraph.\n";
  }
  delete $graph{$graph};
}

1;
