package webtable;

%table = ( );

sub CgiStart {
my ($str, $key, $val);

  if($ENV{'REQUEST_METHOD'} ne 'GET') {
    print "Content-type: text/plain\n\n";
    print "You tried to access this form with a method other than GET.  Only GET\n";
    print "method is supported by this form.\n";
    exit;
  }

  for $str (split(/[&;]/,$ENV{'QUERY_STRING'})) {
    $str =~ s/\+/ /g;
    ($key, $val) = split(/=/,$str,2);
    $key =~ s/%(..)/pack("c",hex($1))/ge;
    $val =~ s/%(..)/pack("c",hex($1))/ge;
    $main::in{$key} = $val;
  }
}

sub AppendData {
my $table = shift;
my $time = shift;
my ($i, $j);

  if(!defined($time)) {
    die "Too few parameters to AppendData.\n";
  }
  if(!exists($table{$table})) {
    die "No such table ($table) in AppendData.\n";
  }
  $table{$table}{"Samples"}++;
  if(!exists($table{$table}{"TimeExtrema"})) {
    $table{$table}{"TimeExtrema"} = [ $time, $time ];
  } else {
    $table{$table}{"TimeExtrema"}[1] = $time;
  }
  for($i = 0; $i < 4; $i++) {
    die "Too few parameters to AppendData" if (!defined ($j = shift));
    $table{$table}{"Sums"}[$i] += $j;
  }
  if(shift) {
    die "Too many parameters to AppendData.\n";
  }
}

sub PrintArray {
  my $array = shift;
  my $indent = shift;
  my $elem;

  if(shift) {
    die "Too many parameters to PrintArray.\n";
  }
  if(!defined($indent)) {
    die "Too few parameters to PrintArray.\n";
  }
  print $indent."Array Values:\n";
  for $elem (@{$array}) {
    if(!defined($elem)) {
      print $indent."  Undefined entry.\n";
    } elsif($elem =~ /^HASH\(.*\)$/) {
      PrintHash($elem, $indent."  ");
    } elsif($elem =~ /^ARRAY\(.*\)$/) {
      PrintArray($elem, $indent."  ");
    } else {
      print $indent."  Plain Value: $elem\n";
    }
  }
  print $indent."End of Array.\n";
}

sub PrintHash {
  my $hash = shift;
  my $indent = shift;
  my $elem;

  if(shift) {
    die "Too many parameters to PrintHash.\n";
  }
  if(!defined($indent)) {
    die "Too few parameters to PrintHash.\n";
  }
  print $indent."Hash Values:\n";
  for $elem (keys %{$hash}) {
    print $indent."  Element: $elem\n";
    if(!defined(${$hash}{$elem})) {
      print $indent."    Undefined entry.\n";
    } elsif(${$hash}{$elem} =~ /^HASH\(.*\)$/) {
      PrintHash(${$hash}{$elem}, $indent."    ");
    } elsif(${$hash}{$elem} =~ /^ARRAY\(.*\)$/) {
      PrintArray(${$hash}{$elem}, $indent."    ");
    } else {
      print $indent."    Plain Value: ${$hash}{$elem}\n";
    }
  }
  print $indent."End of Hash.\n";
}

sub DumpTable {
my $table = shift;

  if(shift) {
    die "Too many parameters to DumpTable.\n";
  }
  if(!defined($table)) {
    die "Too few parameters to DumpTable.\n";
  }
  print "Table: $table\n";
  PrintHash($table{$table}, "  ");
}

sub InitTable {
my $table = shift;

  if(shift) {
    die "Too many parameters to InitTable.\n";
  }
  if(!defined($table)) {
    die "Too few parameters to InitTable.\n";
  }
  if(exists($table{$table})) {
    die "Table already exists ($table) in InitTable.\n";
  }
  %{$table{$table}} = ( "Samples" => 0, "Sums" => [ 0, 0, 0, 0 ] );
}

sub Divide {
my $x = shift;
my $y = shift;

  if(!$y) {
     "##.##";
  } else {
     sprintf "%0.2f", $x / $y;
  }
}

sub ByNumber {
  $a <=> $b;
}

sub PrintTime {
my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst);

  ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(shift);
  printf "%d:%02d:%02d %d/%d/%d", $hour, $min, $sec, $mday, $mon + 1, $year;
}

sub PrintTable {
my $table = shift;
my $samples = $table{$table}{"Samples"};
my $i;

  if(shift) {
    die "Too many parameters to PrintTable.\n";
  }
  if(!defined($table)) {
    die "Too few parameters to PrintTable.\n";
  }
  print "<TD WIDTH=50>";
  PrintTime($table{$table}{"TimeExtrema"}[0]);
  print "<TD WIDTH=50>";
  PrintTime($table{$table}{"TimeExtrema"}[1]);
  for($i = 0; $i < 4; $i++) {
    print "<TD WIDTH=20>";
    print Divide($table{$table}{"Sums"}[$i],$samples);
  }
}

sub DeleteTable {
my $table = shift;

  if(shift) {
    die "Too many parameters to DeleteTable.\n";
  }
  if(!defined($table)) {
    die "Too few parameters to DeleteTable.\n";
  }
  if(!exists($table{$table})) {
    die "Non-existant table ($table) in DeleteTable.\n";
  }
  delete $table{$table};
}

1;
